# * Copyright (C) 2020 Texas Instruments Incorporated - http://www.ti.com/
#  *
#  *
#  *  Redistribution and use in source and binary forms, with or without
#  *  modification, are permitted provided that the following conditions
#  *  are met:
#  *
#  *    Redistributions of source code must retain the above copyright
#  *    notice, this list of conditions and the following disclaimer.
#  *
#  *    Redistributions in binary form must reproduce the above copyright
#  *    notice, this list of conditions and the following disclaimer in the
#  *    documentation and/or other materials provided with the
#  *    distribution.
#  *
#  *    Neither the name of Texas Instruments Incorporated nor the names of
#  *    its contributors may be used to endorse or promote products derived
#  *    from this software without specific prior written permission.
#  *
#  *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#  *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#  *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#  *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#  *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#  *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#  *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#  *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#  *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#  *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#  *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#  *
# */


from tkinter.filedialog import asksaveasfilename
import global_vars


def save_config(self):
    # Ask the user what the file should be Text File Only
    files = [('Text Document', '.txt')]
    save_file = asksaveasfilename(filetypes=files, defaultextension=".txt")

    if save_file != '':
        # Open the file
        f = open(save_file, 'w+')

        # Write down the application choice
        f.write(str(self.v.get()) + '\n')

        # Write down the Read Port
        selections = [self.Lb1.get(idx) for idx in self.Lb1.curselection()]
        for x in range(len(selections)):
            f.write(selections[x])
        f.write('\n')

        # Write down the Write Port
        selections = [self.Lb2.get(idx) for idx in self.Lb2.curselection()]
        for x in range(len(selections)):
            f.write(selections[x])
        f.write('\n')

        # Write down the Read Selections
        selections = [self.Lb4.get(idx) for idx in self.Lb4.curselection()]
        for x in range(len(selections)):
            f.write(selections[x])
            f.write(":")
        f.write('\n')

        # Write down the Write Selections
        w_list = self.fr_write_back.winfo_children()
        for x in range(len(w_list)):                           # Iterate through the frame content
            if w_list[x].winfo_class() == 'Entry':             # Filter the 'Entries'
                if len(w_list[x].get()) != 0:                  # Check if they aren't empty
                    f.write(w_list[x - 1].cget("text") + ":")  # Write the NV Region Name
                    f.write(w_list[x].get() + ":")             # Write the content
        f.write('\n')

        # Write down the options within the Read Frame
        options = []
        for x in range(self.Lb4.size()):
            options.append(self.Lb4.get(x))
        for x in range(len(options)):
            f.write(options[x] + ":")
        f.write("\n")

        # Write down the Write from File Selection
        f.write(self.w.get())
        if self.w.get() == '1':
            f.write("*" + global_vars.content_file + "\n")

        # Need to save a version of the Configuration File to use
        save_id_file = (save_file.strip('.txt') + '_ID') + '.txt'
        with open(global_vars.id_file, "r") as f0:
            with open(save_id_file, "w") as f1:
                for line in f0:
                    f1.write(line)
            f1.close()
        f0.close()
        f.close()
    return
